﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.Data;
using Inet.Viewer.WinForms;
using Inet.Viewer.WinForms.Prompt;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestSinglePromptValuePanel
    {
        [Test]
        public void TestNoValueButton()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.String, true, false, false, true, false,
                false, null, null, null);
            SinglePromptField f = new SinglePromptField(p1, null);
            f.chkNoValue.Checked = false;
            f.txtValueBox.Text = "test";
            PromptValue v = f.Value;
            Assert.AreEqual("'test'",v.StringRepresentation);

            f.chkNoValue.Checked = true;
            Assert.IsNull(f.Value.Value);

            f.chkNoValue.Checked = false;
            v = f.Value;
            Assert.AreEqual("'test'", v.StringRepresentation);
        }

        [Test]
        public void TestNoNoValueButton()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.Number, true, false, false, true, false,
                false, null, null, null);
            SinglePromptField f = new SinglePromptField(p1, null);
            Assert.IsFalse(f.chkNoValue.Visible);
            f.txtValueBox.Text = "1";
            PromptValue v = f.Value;
            Assert.AreEqual("1", v.StringRepresentation);

            f.txtValueBox.Text = "";
            Assert.IsNull(f.Value.Value);
        }

        [Test]
        public void TestInitialZeroForCurrencyOrNumber()
        {
            PromptData p1 = new PromptData(
                "prompt", null, "desc", new string[] { }, new string[] { }, PromptData.Currency, true, false, false, true, false,
                false, null, null, null);
            SinglePromptField f = new SinglePromptField(p1, null);
            Assert.AreEqual("0", f.txtValueBox.Text);
        }
    }
}
